 ; Ŀ
 ;   Blunt - single shot block replacer.                                   
 ;   Copyright 1994, 1997, 2005, 2008 by Rocket Software Ltd.              
 ;   People with a "u" in their surname are not typically very subtle.     
 ; 

 ; Ŀ
 ;   Subroutine Blunt - single shot block replacer.                        
 ;   Arguments: Old, the name of the block to replace.                     
 ;              New, the name of the replacement block.                    
 ;   If either argument is nil then the other one is used for both names.  
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BLUNT (old new / limch atrq *error* new old ss how scla num esav enam
                         entt pa rota xsc ysc zsc layy blocol bloclt main sub
                                                             tagg cc ccol clt)
 ; Ŀ
 ;   Make sure that a couple of settings are correct for this situation.   
 ; 
  (setq limch (getvar "limcheck"))
  (setvar "limcheck" 0)
  (setq atrq (getvar "attreq"))
  (setvar "attreq" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "attreq" atrq)
   (setvar "limcheck" limch)
  (princ))
 ; Ŀ
 ;   If either block name is nil then use the other one for both.          
 ; 
  (cond ((and old (null new))
         (setq new old))
        ((and new (null old))
         (setq old new)))
 ; Ŀ
 ;   Get an ss of block.                                                   
 ; 
  (if (setq ss (ssget "X" (list (cons 2 old))))
      (progn
 ; Ŀ
 ;   Decide how to reapply attribute values - by Attribute or in Order.    
 ; 
           (setq how "Attribute")
 ;         (setq how "Order")
 ; Ŀ
 ;   Insert blocks at the current scale (nil = current.)                   
 ; 
           (setq scla ())
 ; Ŀ
 ;   The selection set processor loop.                                     
 ; 
           (setq num 0)
           (while (setq esav (setq enam (ssname ss 0)))
                  (grtext -2 (itoa (setq num (1+ num))))
                  (ssdel esav ss)
                  (setq entt (entget enam))
 ; Ŀ
 ;   Find the block insertion, X, Y, and Z scales, rotation and layer.     
 ; 
                  (setq pa (cdr (assoc 10 entt)))
                  (setq rota (cdr (assoc 50 entt)))
                  (if rota
                      (setq rota (/ (* 180 rota) pi))
                      (setq rota 0))
                  (if scla
                      (progn
                           (setq xsc scla)
                           (setq ysc scla)
                           (setq zsc scla))
                      (progn
                           (setq xsc (cdr (assoc 41 entt)))
                           (if (null xsc) (setq xsc 1))
                           (setq ysc (cdr (assoc 42 entt)))
                           (if (null ysc) (setq ysc 1))
                           (setq zsc (cdr (assoc 43 entt)))
                           (if (null zsc) (setq zsc 1))))
                  (setq layy (assoc 8 entt))
                  (setq blocol (assoc 62 entt))          ; colour
                  (setq bloclt (assoc 6 entt))           ; linetype
 ; Ŀ
 ;   Step through the block and get attribute tags and values.             
 ;   (if there are attributes - the 66 sublist is present.)                
 ; 
                  (setq main ())
                  (if (assoc 66 (entget enam))
                      (while (and (setq enam (entnext enam))
                                 (/= (cdr (assoc 0 (setq entt (entget enam))))
                                                                     "SEQEND"))
                             (setq sub (list (assoc 2 entt) (assoc 1 entt)))
                             (setq main (append main (list sub)))))
 ; Ŀ
 ;   Now erase the old new block and insert the new one.                   
 ; 
                  (entdel esav)
                  (command "insert" new pa "xyz" xsc ysc zsc rota)
                  (setq esav (setq enam (entlast)))
 ; Ŀ
 ;   And reapply the attribute values depending on the value of How.       
 ; 
                  (cond ((or (= how "Attribute") (= how "Tag"))
                         (while (and (setq enam (entnext enam))
                                     (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                                (setq tagg (assoc 2 entt))
                                (if (setq cc (assoc tagg main))
                                    (entmod (subst (cadr cc)
                                                   (assoc 1 entt) entt))
                                    (if (null usedef)
                                        (entmod (subst (cons 1 "")
                                                      (assoc 1 entt) entt))))))
                        ((= how "Order")
                         (while (and (setq enam (entnext enam))
                                     (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                                (setq cc (cadar main))
                                (setq main (cdr main))
                                (if cc
                                    (entmod (subst cc (assoc 1 entt) entt))
                                    (if (null usedef)
                                        (entmod (subst (cons 1 "")
                                                     (assoc 1 entt) entt)))))))
 ; Ŀ
 ;   Put the block on the correct layer.                                   
 ; 
                  (setq entt (entget esav))
                  (entmod (setq entt (subst layy (assoc 8 entt) entt)))
 ; Ŀ
 ;   Change the colour (assoc 62).                                         
 ; 
             (cond ((and (setq ccol (assoc 62 entt)) blocol)
                    (entmod (subst blocol ccol entt)))
                   (blocol
                    (entmod (setq entt (append entt (list blocol)))))
                   (ccol
                    (entmod (subst (cons 62 256) ccol entt))))
 ; Ŀ
 ;   Re-entget in case anything has changed.                               
 ; 
             (setq entt (entget esav))
 ; Ŀ
 ;   Change the linetype (assoc 6).                                        
 ; 
             (cond ((and (setq clt (assoc 6 entt)) bloclt)
                    (entmod (subst bloclt clt entt)))
                   (bloclt
                    (entmod (setq entt (append entt (list bloclt)))))
                   (clt
                    (entmod (subst (cons 6 256) clt entt)))))))
 ; Ŀ
 ;   Report.                                                               
 ; 
  (if num (write-line (strcat (itoa num) " block"
                              (if (= num 1) "" "s") " replaced.")))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (setvar "attreq" atrq)
  (setvar "limcheck" limch)
 (princ))
 ; Ŀ
 ;   Subroutine Blunt end.                                                 
 ; 

 ; Ŀ
 ;   Blunt.                                                                
 ; 
 (DEFUN C:BLUNT (/ osmo *error* enampt enam entt old new)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (setvar "osmode" osmo)
  (if shk (write-line shk))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Set the existing and replacement block names.                         
 ; 
  (if (and (setq enampt (entsel "Block to update: "))
           (setq enam (car enampt))
           (setq entt (entget enam))
           (equal (cdr (assoc 0 entt)) "INSERT"))
      (setq new (cdr (assoc 2 (entget enam))))
      (prompt "Bad selection."))
 ; Ŀ
 ;   Call blunt to find and replace the blocks.                            
 ; 
  (blunt old new)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))